/** @file   sentrygunai.h
 * @brief   Declaration of SentryGunAI - class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:42 $
 * @author  Tomi Lamminsaari
 */

#ifndef SENTRYGUNAI_H
#define SENTRYGUNAI_H

#include "aicontroller.h"


namespace WeWantWar {

/** @class  SentryGunAI
 * @brief   Has the logic that controls the SentryGun
 * @author  Tomi Lamminsaari
 *
 */
class SentryGunAI : public AIController
{
public:
  /** Constructor.
   * @param     pObject           Pointer to GameObject we're controlling.
   */
  SentryGunAI(GameObject* pObject);

  /** Destructor.
   */
  virtual ~SentryGunAI();
  
  
  ///
  /// Methods
  /// =======
  
  /** Updates this controller.
   */
  virtual void updateAI( bool seeTarget, float dist );
  
  
  
  ///
  /// Getter-methods
  /// ==============
  
  
  
protected:

  ///
  /// Members
  /// =======
  
  /** How far we can see the enemy */
  float   m_viewDistance;
  /** How far we can shoot him */
  float   m_shootingRange;
  
  
private:
  /** Disabled copy constructor. */
  SentryGunAI( const SentryGunAI* pO );
  /** Disabled assignment operator */
  SentryGunAI& operator = ( const SentryGunAI& rO );
};

};  // end of namespace

#endif // SENTRYGUNAI_H

/**
 * Version history
 * ===============
 * $Log: sentrygunai.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:14+02  lamminsa
 * Initial revision
 *
 */
